"use strict";

/********************************************************/
/***** Settings/Configuration
/********************************************************/
var params = {
	'archer_username':"dfm_BitsightVRMAPINightly",	//Example used in Installation Guide. Update name if you changed it.
	'archer_password':"YOURPASSWORD",
	'archer_instanceName':'INSTANCENAME', 			//Example: 88555 or Dev						Instance name is case-sensitive. SaaS instances are typically numbers
	'archer_webroot':"https://ARCHERURL.com/",		//Example: https://archerDev.company.com/	Must include trailing slash
	'archer_webpath':"RSAarcher/", 					//Example: RSAarcher/						Must include trailing slash UNLESS there is no virtual directory...then leave blank - Preconfigured for Archer SaaS environment
	'archer_ws_root':"RSAarcher/ws/",				//Example: RSAarcher/ws/					Must include trailing slash and vdir is case-sensitive - Preconfigured for Archer SaaS environment
	'archer_rest_root':"RSAArcher/platformapi/",	//Example: RSAarcher/platformapi/			Must include trailing slash and vdir is case-sensitive - Preconfigured for Archer SaaS environment

	'Bitsight_token':"YOUR_Bitsight_TOKEN",     	//Bitsight API Token for authentication - Can be personal or company token. Company token is preferred.

	//Application Names
	"archer_ThirdPartyProfileApp": "Third Party Profile", //Name of the "Third Party Profile" application in Archer for your organization. May be called Vendors, Vendor Profiles, etc.
	"archer_BitsightVRMFindings": "Bitsight VRM Findings", //Name of the "Bitsight VRM Findings" questionnaire in Archer for your organization.

	//Typically these will not change
	"Bitsight_webroot": "https://service.Bitsighttech.com/", //Example: https://service.Bitsighttech.com/		Main Bitsight API URL				*Must include trailing slash
	"Bitsight_addMonitoredVendor": "customer-api/vrm/v1/vendors/monitored", //Example: vrm/v1/vendors/monitored			Endpoint for adding vendors to be monitored by domain or guid.
	"Bitsight_getcompanytags": "customer-api/vrm/v1/tags", //Example: customer-api/vrm/v1/tags			Endpoint for getting the company tags
	"Bitsight_getcompanylifecycles": "customer-api/vrm/v1/life-cycle-stages", //Example: customer-api/vrm/v1/life-cycle-stages			Endpoint for getting the lifecycles
	"Bitsight_listallvendors": "customer-api/vrm/v1/vendors/query", //Example: customer-api/vrm/v1/vendors/query			Lists all vendors in Bitsight VRM

	//Params to generate the link to the Bitsight portal
	//Example: https://service.Bitsighttech.com/app/vrm/profile/managed/96f2d60f-e86a-45ad-b5b0-ce33e1538377/overview
	//Example: https://service.Bitsighttech.com/app/vrm/profile/monitored/4c81e8c0-abe4-49ba-9079-89202e51759e/overview
	"Bitsight_monitoredvendorpath": "app/vrm/profile/monitored/", //Portion of the url for clients to access Monitored vendors
	"Bitsight_managedvendorpath": "app/vrm/profile/managed/", //Portion of the url for clients to access Managed vendors
	"Bitsight_overviewpath": "/overview", //the end part of the url for clients to access vendors in the portal.

	//API path to get vendor details - specifically the Bitsight GUID (bst_entity_guid) so we can get the Rating
	"Bitsight_monitoredvendorpathapi": "customer-api/vrm/v1/vendors/monitored/", //Portion of the api to access Monitored vendors (needed to get Bitsight GUID)
	"Bitsight_managedvendorpathapi": "customer-api/vrm/v1/vendors/managed/", //Portion of the api to access Managed vendors (needed to get Bitsight GUID)

	"Bitsight_vendorratingpathapi": "customer-api/vrm/v1/companies/", //Needed to get the Bitsight Security Rating details - https://service.Bitsighttech.com/customer-api/vrm/v1/companies/{bst_entity_guid}/rating

	//Bitsight: List Vendors Findings
	//Documentation: https://Bitsight.stoplight.io/docs/VRM-api/uxk1yjtssm95w-list-vendors-findings
	"Bitsight_vendorfindingsapi": "customer-api/vrm/v1/vendors/findings/query", //Needed to get the Bitsight Vendor Findings - POST to https://service.Bitsighttech.com/customer-api/vrm/v1/vendors/findings/query

	//Get Vendor Requirement Progress
	//Documentation: https://Bitsight.stoplight.io/docs/VRM-api/51rip3itf833e-vendor-requirements-progress
	"Bitsight_vendorrequirementprogresspathapi": "customer-api/vrm/v1/vendors/", //Needed to get the Bitsight Assessment Progress- https://service.Bitsighttech.com/customer-api/vrm/v1/vendors/{vendor_guid}/requirements

	"Bitsight_getfindingstatusesapi": "customer-api/vrm/v1/findings/statuses", //Needed to get the list of Finding Statuses: https://service.Bitsighttech.com/customer-api/vrm/v1/findings/statuses

	//Bitsight API Settings
	"Bitsightvrmapi_limit": 10, //Max limit of records returned for the List Vendors Findings endpoint. Default is 10.

	//Typically these will not change unless Archer changes the structure
	"archer_searchpath": "search.asmx", //Example: search.asmx
	"archer_fieldpath": "field.asmx", //Example: field.asmx
	"archer_loginpath": "core/security/login", //Example: security/login (REST method)
	"archer_contentpath": "core/content", //Example: core/content				//Do NOT include trailing slash
	"archer_applicationpath": "core/system/application/", //Example: core/system/application/							Must include trailing slash
	"archer_questionnairepath": "core/system/questionnaire/", //Example: core/system/questionnaire/							Must include trailing slash
	"archer_fielddefinitionapppath": "core/system/fielddefinition/application/", //Example: core/system/fielddefinition/application/			Must include trailing slash
	"archer_fielddefinitionpath": "core/system/fielddefinition/", //Example: core/system/fielddefinition/						Must include trailing slash
	"archer_valueslistvaluepath": "core/system/valueslistvalue/flat/valueslist/", //Example: core/system/valueslistvalue/flat/valueslist/		Must include trailing slash
	"archer_version": "core/system/applicationinfo/version", //Example: core/system/applicationinfo/version				Do NOT include trailing slash
	"archer_getlevelidpath": "core/system/level/module/", //Example: core/system/level/module/							Must include trailing slash

	//Populated later
	"archer_ThirdPartyProfileAppID": "", //App ID of the Third Party Profile application. Populated before getting fields.
	"archer_ThirdPartyProfileLevelID": "", //Level ID of the Third Party Profile application needed for updates to records. Populated after getting fields.
	"archer_VendorFindingsAppID": "", //App ID of the Vendor Findings questionnaire. Populated before getting fields.
	"archer_VendorFindingsLevelID": "", //Level ID of the Vendor Findings questionnaire needed for updates to records. Populated after getting fields.
};

//Archer: Third Party Profile application field names. The field names are listed below and must match Archer exactly!
var ArcherTPPFieldParams = {
	"Bitsight VRM Tags": null,
	"Bitsight VRM Deep Link": null,
	"Bitsight VRM Domain": null,
	"Bitsight Security Rating": null,
	"Bitsight VRM GUID": null,
	"Bitsight VRM Impact Score": null,
	"Bitsight GUID": null,
	"Bitsight VRM Lifecycle": null,
	"Bitsight VRM Last Updated Date": null,
	"Bitsight VRM Requirements Completion %": null,
	"Bitsight VRM Requirements Due Date": null,
	"Bitsight VRM Review Year": null,
	"Bitsight VRM Trust Score": null,
	"Bitsight VRM Risk Score": null,
};

//Archer: Bitsight Vendor Findings application field names. The field names are listed below and must match Archer exactly!
var ArcherVendorFindingsFieldParams = {
	"Archer ID": null,
	"Related Third Party Profile": null,
	"Finding Status": null,
	"Criticality": null,
	"Will Remediate By": null,
	"Bitsight Finding ID": null,
	"Creation Date": null,
	"Reported On": null,
};

module.exports = { params, ArcherTPPFieldParams, ArcherVendorFindingsFieldParams };
